import React, { useState } from 'react';
import Tabs from '../../common/Tabs'; // Adjust the path as needed
import ServicesList from './ServicesList';
import NewServices from './AddServices';

// Corrected imports for Pricing Rules components
import PricingrulesList from '../Pricingrules/PricingrulesList';
import NewPricingrules from '../Pricingrules/AddPricingrules';

// Corrected imports for Pricing Types
import PricingtypesList from '../Pricingtypes/PricingtypesList';
import NewPricingtypes from '../Pricingtypes/AddPricingtypes';

const Services = () => {
  const tabsData = [
    { id: 'list', label: 'Services List' },
    { id: 'new', label: 'New Services' },
    { id: 'pricingruleslist', label: 'Pricing Rules' },
    { id: 'pricingrulesnew', label: 'New Pricing Rules' },
    { id: 'pricintypeslist', label: 'Pricing Types' },
    { id: 'pricingtypesnew', label: 'New Pricing Types' },
  ];

  return (
    <div className="roles-container">
      <h2>Services Management</h2>
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'list':
              return <ServicesList />;
            case 'pricingruleslist':
              return <PricingrulesList />;
            case 'new':
              return <NewServices />;
            case 'pricingrulesnew':
              return <NewPricingrules />;
            case 'pricintypeslist':
              return <PricingtypesList />;
            case 'pricingtypesnew':
              return <NewPricingtypes />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Services;
