import React, { useState, useEffect } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const UserView = ({ userId, onClose }) => {
  const [userData, setUserData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/services/${userId}`)
      .then(res => {
        setUserData(res.data);
        setLoading(false);
      })
      .catch(err => {
        setError('Error fetching user details.');
        setLoading(false);
      });
  }, [userId]);

  if (loading) {
    return (
      <Modal title="View User" onClose={onClose}>
        <div>Loading user details...</div>
      </Modal>
    );
  }

  if (error) {
    return (
      <Modal title="View Pricing Rules" onClose={onClose}>
        <div style={{ color: 'red' }}>{error}</div>
      </Modal>
    );
  }

  return (
    <Modal title="View Services" onClose={onClose}>
      <div className="user-details">
        <p><strong>Rules Name:</strong> {userData.rule_name}</p>
        <p><strong>Pricing Type:</strong> {userData.pricing_type}</p>
        <p><strong>Base Cost:</strong> {userData.base_cost}</p>        
        <p><strong>Rate:</strong> {userData.rate}</p>        
        <p><strong>Unit:</strong> {userData.unit}</p>         
        <p><strong>Conditions:</strong> {userData.conditions}</p>         
        <p><strong>Created Date:</strong> {userData.created_date}</p>
        <p><strong>Status:</strong> {userData.status=='A' ? 'Active' : 'Inactive'}</p>
        {/* Add other fields as necessary */}
      </div>
    </Modal>
  );
};

export default UserView;
