import React, { useState } from 'react';
import SearchPage from '../../common/SearchPage';
import List from '../../common/List';

import UserView from './ServicesView';
import UserUpdate from './ServicesUpdate';
import UserDB from './ServicesDB';

const ROLES_HEADER_TO_KEY_MAP = {
  "Service Name": "service_title",
  "Service Description": "service_description",
  "Created Date": "created_date",
};

const UsersList = ({ initialSearchQuery = '', rowsPerPage = 10 }) => {
  const fetchDataUrl = `/services/list/all/`;
  // selectedRole holds an object: { roleId, modalType }
  const [selectedUser, setSelectedUser] = useState(null);

  const actionFormats = [
    { label: "view", modal:true, url: "/services/view/{id}" },
    { label: "delete", modal:true, url: "/services/delete/{id}" },
    { label: "block", modal:true, url: "/services/delete/{id}" },
    { label: "edit", modal:true, url: "/services/update/{id}" }
  ];

  const handleActionClick = (userId, action) => {
    if (action.label === "view") {
      console.log("userIduserIduserIduserIduserId")
      console.log(userId)
      setSelectedUser({ userId, modalType: "view" });
    } else if (action.label === "edit") {
      console.log("EDIT FORM CALLING 3111111111111111111111") 
      setSelectedUser({ userId, modalType: "update" });
    } else if (action.label === "delete" || action.label === "block") {
      setSelectedUser({ userId, modalType: "delete" });
    }
  };

  const closeModal = () => setSelectedUser(null);

  return (
    <div>
      <SearchPage
        fetchDataUrl={fetchDataUrl}
        ListComponent={List}
        itemKeyMapping={ROLES_HEADER_TO_KEY_MAP}
        dataKey="users"
        identifierKey="user_id"
        initialSearchQuery={initialSearchQuery}
        rowsPerPage={rowsPerPage}
        actionFormats={actionFormats}
        onActionClick={handleActionClick}
        // You can add searchFields if needed
      />
      
      {selectedUser && selectedUser.modalType === "view" && (
        <UserView 
          userId={selectedUser.userId}
          onClose={closeModal}
        />
      )}
      {selectedUser && selectedUser.modalType === "update" && (
        <UserUpdate 
          userId={selectedUser.userId}
          onClose={closeModal}
          onUpdateSuccess={() => console.log("User updated")}
        />
      )}
      {selectedUser && selectedUser.modalType === "delete" && (
        <UserDB 
          userId={selectedUser.userId}
          onClose={closeModal}
          onDeleteSuccess={() => console.log("User deleted")}
        />
      )}


    </div>
  );
};

export default UsersList;
