import React from "react";

// Custom widget for file upload handling
const CustomFileWidget = ({ value, onChange }) => {
  const handleChange = (event) => {
    const file = event.target.files[0];
    if (file) {
      const reader = new FileReader();
      reader.onloadend = () => {
        onChange(reader.result);
      };
      reader.readAsDataURL(file);
    }
  };

  return (
    <div>
      <input type="file" onChange={handleChange} />
      {value && (
        <div style={{ marginTop: "10px" }}>
          <img
            src={value}
            alt="Preview"
            style={{ maxWidth: "100px", maxHeight: "100px" }}
          />
        </div>  
      )}
    </div>
  );
};

export default CustomFileWidget;
