// Roles.js
import React from 'react';
import Tabs from '../../common/Tabs';
import RolesList from './RolesList';
import NewRole from './AddRole';
import PageHeader from '../../common/Header/PageHeader';
import DefaultRoles from './DefaultRoles';
import Features from './Features';

const Roles = () => {
  const tabsData = [
    { id: 'default', label: 'Basic Roles' },
    { id: 'list', label: 'All Roles' },
    { id: 'new', label: 'New +' },
    { id: 'features', label: 'Features' },
    { id: 'update', label: 'Update Basic Roles' },
  ];

  return (
    <div className="roles-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'default':
              return <RolesList key="default" isDefaultRoles={true} />;
            case 'list':
              return <RolesList key="custom" isDefaultRoles={false} />;
            case 'new':
              return <NewRole />;
            case 'features':
              return <Features />;
            case 'update':
              return <DefaultRoles />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Roles;
