import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import { Link } from 'react-router-dom';

const RoleDelete = ({ roleId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');
  const [successMessage, setSuccessMessage] = useState('');

  const deleteRole = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/roles/${roleId}`)
      .then(res => {
        setSuccessMessage("Role deleted successfully.");
        if (onDeleteSuccess) onDeleteSuccess();
        // Automatically close the modal after 2 seconds
        setTimeout(() => {
          onClose();
        }, 2000);
      })
      .catch(err => {
        setError("Error deleting role.");
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete Role" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      {successMessage ? (
        <p className="success">{successMessage}</p>
      ) : (
        <>
          <p>Are you sure you want to delete this role?</p>
          <button onClick={deleteRole} disabled={isSubmitting}>Confirm</button>
        </>
      )}
    </Modal>
  );
};

export default RoleDelete;
