import React, { useState } from 'react';
import axios from 'axios';

const DefaultRoles = () => {
  const [loading, setLoading] = useState(false);
  const [message, setMessage] = useState('');

  const handleUpdateDefaults = async () => {
    setLoading(true);
    setMessage('');
    try {
      const response = await axios.post('/rbac/default');
      setMessage('Default roles updated successfully.');
      console.log('Default roles response:', response.data);
      // Optionally refresh your roles list here.
    } catch (error) {
      console.error('Error updating default roles:', error);
      setMessage('Error updating default roles.');
    }
    setLoading(false);
  };

  return (
    <div>
      <p>This page is setting up default roles set in the backend...</p>
      <button onClick={handleUpdateDefaults} disabled={loading}>
        {loading ? 'Updating...' : 'Set Default'}
      </button>
      {message && <p>{message}</p>}
    </div>
  );
};

export default DefaultRoles;
