import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import RoleForm from './RoleForm';

const NewRole = ({ onClose, onCreateSuccess }) => {
  const [success, setSuccess] = useState(false);
  const [message, setMessage] = useState('');

  const handleSubmit = (formData) => {
    axios.post(`/roles/`, formData)
      .then(res => {
        setSuccess(true);
        setMessage("Role created successfully!");
        if (onCreateSuccess) onCreateSuccess(res.data);
        // Optionally, you can clear or hide the form by not rendering it when success is true.
        // You might also call onClose() after a timeout if you want the modal to close automatically.
      })
      .catch(err => {
        //alert("Error creating role.");
      });
  };

  return (
    <>
      {success ? (
        <div className="success">
          {message}
        </div>
      ) : (
        <RoleForm onSubmit={handleSubmit} />
      )}
      </>
  );
};

export default NewRole;
