import React from 'react';
import PageHeader from '../../common/Header/PageHeader';
import Tabs from '../../common/Tabs';
import PartnerList from './PartnerList';
import Invite from '../../common/Invite'; // updated path if moved

const Partners = () => {
  const tabsData = [
    { id: 'list', label: 'Partners' },
    { id: 'new', label: 'Invite' },
  ];

  return (
    <div className="partners-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'list':
              return <PartnerList initialSearchQuery="" />;
            case 'new':
              return <Invite defaultRoleId="3" />; // Role 3 is for partners
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Partners;
