import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const PartnerDB = ({ partnerId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deletePartner = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/partners/${partnerId}`)
      .then(res => {
        alert("Partner deleted successfully.");
        if (onDeleteSuccess) onDeleteSuccess();
        onClose();
      })
      .catch(err => {
        setError("Error deleting Partner.");
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete/Block Partner" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete or block this Partner?</p>
      <button onClick={deletePartner} disabled={isSubmitting}>Confirm</button>
      <button onClick={onClose}>Cancel</button>
    </Modal>
  );
};

export default PartnerDB;
