import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import PartnerForm from './PartnerForm';

const NewPartner = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {
    axios.post(`/partners/`, formData)
      .then(res => {
        alert("Partner created successfully!");
        if (onCreateSuccess) onCreateSuccess(res.data);
        if (onClose) onClose();
      })
      .catch(err => {
        alert("Error creating Partner.");
      });
  };

  return (
      <PartnerForm onSubmit={handleSubmit} />
  );
};

export default NewPartner;
