import React from 'react';
import Tabs from '../../common/Tabs';
import InvoiceList from './InvoiceList';
import AddInvoice from './AddInvoice';

const Invoices = () => {
  const tabs = [
    { id: 'invoice_list', label: 'Invoice List' },
    { id: 'new_invoice', label: 'Add' },
  ];

  return (
    <div className="invoices-container">
      <Tabs tabs={tabs}>
        {(active) => {
          switch (active) {
            case 'invoice_list': return <InvoiceList />;
            case 'new_invoice':  return <AddInvoice />;
            default: return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Invoices;
