import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const InvoiceDB = ({ invoiceId, onClose, onDeleteSuccess }) => {
  const [busy, setBusy] = useState(false);
  const [err, setErr] = useState('');

  const onDelete = async () => {
    if (busy) return;
    try {
      setBusy(true);
      await axios.delete(`/invoices/${invoiceId}`); // delete (plural path like tickets)
      alert('Invoice deleted successfully');
      onDeleteSuccess && onDeleteSuccess();
      onClose && onClose();
    } catch (e) {
      console.error(e);
      setErr('Error deleting invoice.');
    } finally {
      setBusy(false);
    }
  };

  return (
    <Modal title="Delete Invoice" onClose={onClose}>
      {err && <div style={{ color: 'red', marginBottom: 12 }}>{err}</div>}
      <p>Are you sure you want to delete this invoice?</p>
      <div style={{ display: 'flex', gap: 12, marginTop: 16 }}>
        <button
          onClick={onDelete}
          disabled={busy}
          style={{ background: busy ? '#ccc' : '#ff4d4f', color: '#fff', border: 0, padding: '8px 16px', borderRadius: 4 }}
        >
          {busy ? 'Deleting…' : 'Delete'}
        </button>
        <button onClick={onClose} style={{ background: '#f5f5f5', border: '1px solid #d9d9d9', padding: '8px 16px', borderRadius: 4 }}>
          Cancel
        </button>
      </div>
    </Modal>
  );
};

export default InvoiceDB;
