import React from 'react';
import axios from 'axios';
import InvoiceForm from './InvoiceForm';

const AddInvoice = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = async (formData) => {
    try {
      const payload = {
        ...formData,
        user_id: localStorage.getItem('user_id') || '',
        account_id: localStorage.getItem('account_id') || ''
      };
      const res = await axios.post('/invoices/', payload); // create
      alert('Invoice created successfully');
      onCreateSuccess && onCreateSuccess(res.data);
      onClose && onClose();
    } catch (e) {
      console.error(e);
      alert('Error creating invoice');
    }
  };

  return (
    <div style={{ maxWidth: 720, padding: 20 }}>
      <InvoiceForm onSubmit={handleSubmit} isUpdateForm={false} />
    </div>
  );
};

export default AddInvoice;