import React from 'react';
import CrudModule from '../common/CRUD/CrudModule';

// Inline JSON schema for the city form.
const citySchema = {
  title: "City",
  type: "object",
  required: ["name", "country"],
  properties: {
    name: { type: "string", title: "City Name" },
    state: { type: "string", title: "State" },
    country: { type: "string", title: "Country" },
  }
};

// Inline UI schema for the city form.
const cityUiSchema = {
  state: { "ui:placeholder": "Enter state" }
};

const Cities = () => {
  const collectionName = "dummycities";

  return (
    <CrudModule
      collectionName={collectionName}
      title="Cities"
      description="Manage cities in the system."
      headerMapping={{
        "City": "name",
        "State": "state",
        "Country": "country",
        "Created": "created_date",
      }}
      dataKey="items"
      identifierKey="dummycities_id"  // Ensure this matches your backend auto-field
      schema={citySchema}
      uiSchema={cityUiSchema}
      // Explicit fetchUrl to call the proper endpoint
      fetchUrl="/crud/dummycities/"
      searchFields={[
        {
          name: 'q',
          type: 'text',
          placeholder: 'Search cities...',
        },
      ]}
      rowsPerPage={10}
      actionFormats={[
        { label: "view", modal: true, url: "/cities/view/{dummycities_id}" },
        { label: "edit", modal: true, url: "/cities/update/{dummycities_id}" },
        { label: "delete", modal: true, url: "/cities/delete/{dummycities_id}" },
      ]}
    />
  );
};

export default Cities;
