import React, { useState, useEffect } from 'react';
import { useNavigate, useParams } from 'react-router-dom';
import Tabs from "../../common/Tabs";
import AppsList from "./AppsList";
import NewApp from "./NewApp";

const Apps = () => {
    const { app_id } = useParams();
    const navigate = useNavigate();
    const roles = localStorage.getItem('roles') || '1';
    const [appId, setAppId] = useState(null);
    const [activeTab, setActiveTab] = useState(app_id ? 'newapp' : 'appslist');

    const tabsData = [
        { id: 'appslist', label: 'Apps' },
        { id: 'newapp', label: '+ App' }
    ];

    useEffect(() => {
        if (roles !== '1') {
            console.log("user_ROLES::" + roles);
            navigate('/logout');
        }
    }, [roles, navigate]);

    const handleTabChange = (newActiveTab) => {
        setActiveTab(newActiveTab);
    };

    return (
        <div className="dashboard-container">
            <Tabs tabs={tabsData} activeTabId={activeTab} onTabChange={handleTabChange}>
                {(currentTab) => (
                    <>
                        <div className={`AppsList ${currentTab === 'appslist' ? 'newactive' : ''}`}>
                            <AppsList setActiveTab={setActiveTab} setAppId={setAppId} initialSearchQuery="" />
                        </div>
                        <div className={`NewApp ${currentTab === 'newapp' || app_id ? 'newactive' : ''}`}>
                            <NewApp key={appId} appId={appId} />
                        </div>
                    </>
                )}
            </Tabs>
        </div>
    );
};

export default Apps;
