import React, { useEffect, useState } from 'react';
import axios from 'axios';

const DeleteApp = ({ EditAppId }) => {
    const [appName, setAppName] = useState('');
    const [message, setMessage] = useState('');
    const [isError, setIsError] = useState(false);

    useEffect(() => {
        if (EditAppId) {
            fetchAppData(EditAppId);
        }
    }, [EditAppId]);

    const fetchAppData = async (id) => {
        try {
            const response = await axios.get(`/appflow/a/${id}`);
            const data = response.data;
            setAppName(data.name || '');
        } catch (error) {
            console.error("Error fetching app data:", error);
            setMessage("Failed to fetch app details.");
            setIsError(true);
        }
    };

    const deleteApp = async () => {
        const confirmation = window.confirm(`Are you sure you want to delete ${appName ? appName : 'this app'}?`);
        if (!confirmation) {
            return; // Stop if the user does not confirm
        }

        // Ask for the password
        const password = window.prompt("Enter the password to confirm deletion:");
        if (password !== 'whiter34') {
            alert('Incorrect password. Deletion cancelled.');
            return; // Incorrect password, do not proceed
        }

        try {
            const response = await axios.delete(`/appflow/delete/${EditAppId}`);
            if (response.status === 200 || response.status === 204) {
                setMessage(`${appName ? appName : 'App'} deleted successfully.`);
                setIsError(false);
            }
        } catch (error) {
            console.error("Error deleting the app:", error);
            setMessage("Failed to delete the app.");
            setIsError(true);
        }
    };


    return (
        <div>
            <h1>{appName && `${appName}`}</h1>
            <p>App ID: {EditAppId}</p>
            <button onClick={deleteApp}>Delete App</button>
            {message && <p style={{ color: isError ? 'red' : 'green' }}>{message}</p>}
        </div>
    );
};

export default DeleteApp;
