import React, {useEffect, useState} from "react";
import SearchPage from '../../common/SearchPage';
import List from '../../common/List/Icons';
import AppModal from './NewApp';
import AppDelete from './DeleteApp';
import IntegrationModal from '../../common/Modal/Integration';


const PROJECTS_HEADER_TO_KEY_MAP = {
    "Name": { key: "name", clickable: true },
    "Title": { key: "title", clickable: false },
    "Integrations": { key: "integrations", clickable: false },
    "Icon": { key: "icon", clickable: false },
    "Date": { key: "updated_date", clickable: false },
    "Status": { key: "status", clickable: false },
  };

  const AppsList = ({ initialSearchQuery = '', rowsPerPage = 50, setActiveTab, setAppId }) => {

    const fetchDataUrl = `/appflow/`;
    const [selectedAppId, setSelectedAppId] = useState(null);
    const [mode, setMode] = useState("");

    const actionFormats = [
      { label: "edit", modal: true,  url: "/a/apps/edit/{id}" },
      { label: "delete", modal: true,  url: "/a/apps/delete/{id}" },
      { label: "test", modal: true,  url: "/a/apps/test/{id}" }
    ];

    const handleActionClick = (app_id, action) => {
      setSelectedAppId(app_id);
      setMode(action.label); 
    };
    
      return (
        <div>
        <SearchPage
          fetchDataUrl={fetchDataUrl}
          ListComponent={List}
          itemKeyMapping={PROJECTS_HEADER_TO_KEY_MAP}
          dataKey="apps"
          identifierKey="_id"
          initialSearchQuery={initialSearchQuery}
          rowsPerPage={rowsPerPage}
          actionFormats={actionFormats}
          onActionClick={handleActionClick}
        />
        {mode==="edit" && selectedAppId && (
        <div className="modal-overlay">
          <div className="modal-content">
          <h1>Edit App </h1>
            <div className='closeontoprightflow'>
            <a href="#" onClick={() => setSelectedAppId(null)}  ><span className="material-symbols-outlined">close</span></a>
            </div>
              <AppModal
              EditAppId={selectedAppId} 
              />
            </div>
          </div>
        )}
        {mode==="delete" && selectedAppId && (
        <div className="modal-overlay">
          <div className="modal-content">
          <h1>Delete App </h1>
            <div className='closeontoprightflow'>
            <a href="#" onClick={() => setSelectedAppId(null)}  ><span className="material-symbols-outlined">close</span></a>
            </div>
              <AppDelete
              EditAppId={selectedAppId} 
              />
            </div>
          </div>
        )}
        { mode==="test" && selectedAppId && (
                <IntegrationModal
                appId={selectedAppId} 
                onClose={() => setSelectedAppId(null)} 
                />
            )}
        </div>
      );
    }

export default AppsList;
