import React from 'react';
import { usePermission } from '../../../state/usePermission';
import PageHeader from '../../common/Header/PageHeader';
import Tabs from '../../common/Tabs';
import AccountsList from './AccountsList';
import AddAccount from './AddAccount';
import Invite from '../../common/Invite';

const Accounts = ({ featureId }) => {
  const { canCreate } = usePermission(featureId);
  const isGlobalAccess = localStorage.getItem('is_global_access') === 'true';
  const accountId = localStorage.getItem('account_id');

  const tabsData = [
    { id: 'list', label: 'Accounts' },
    { id: 'invite', label: 'Invite' },
    ...(canCreate ? [{ id: 'new', label: 'Add' }] : []), //Conditional
  ];

  return (
    <div className="accounts-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'list':
              return <AccountsList featureId={featureId} isGlobalAccess={isGlobalAccess} accountId={accountId} />;
            case 'invite':
              return <Invite defaultRoleId="100" />;
            case 'new':
              return <AddAccount />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Accounts;
