import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const AccountDB = ({ accountId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteAccount = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/accounts/${accountId}`)
      .then(res => {
        alert("Account deleted successfully.");
        if (onDeleteSuccess) onDeleteSuccess();
        onClose();
      })
      .catch(err => {
        setError("Error deleting account.");
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete/Block Account" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete or block this account?</p>
      <button onClick={deleteAccount} disabled={isSubmitting}>Confirm</button>
    </Modal>
  );
};

export default AccountDB;
