import React, { useEffect } from 'react';
import { useLocation } from 'react-router-dom';
import Header from '../common/Header';  // Assuming you have a Header component
import Footer from '../website/Footer';
import '../themes/blue/website.css';

const Layout = ({ children, color='blue' }) => {
  const location = useLocation(); // Use the useLocation hook here

  /*
  useEffect(() => {
    // Set the CSS variable to the desired color
    document.documentElement.style.setProperty('--dynamic-color', color);
  }, [color]);
*/
  useEffect(() => {
    // Scroll to the top every time the location changes
    window.scrollTo(0, 0);
  }, [location]); // Reacting to changes in location.pathname


  return (
    <div className="layout-container">
      <Header />
      <div className="website-content-container">
            {children}
      </div>
      <Footer />
    </div>
  );
}

export default Layout;
