import React from 'react';
import '../themes/blue/Modal.css';

const Modal = ({ title, children, onClose }) => {

  const handleOverlayClick = (e) => {
    if (e.target === e.currentTarget) {
      onClose();
    }
  };

  return (
    <div className="modal-overlay" onClick={handleOverlayClick}>
      <div className="modal-content">
        {title && <h2 className="modal-title">{title}</h2>}
        <a href='#' className="close-button" onClick={onClose}>×</a>
        <div className="modal-body">
          {children}
        </div>
      </div>
    </div>
  );
};

export default Modal;
