import React, { useEffect } from 'react';
import Menu from '../common/Menu/Menu';
import PageHeader from '../common/Header/PageHeader'; // ✅ import your header
import { useNavigate } from 'react-router-dom';
import '../themes/blue/List.css';
import '../themes/blue/Tabs.css';
import '../themes/blue/Layout.css';

const AdminLayout = ({ children, title, description }) => {
  const navigate = useNavigate();

  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  return (
    <div className="layout-container">
      <div className="body-section">
        <Menu />
        <div className="content-area-layout">
          <PageHeader title={title} description={description} /> {/* ✅ cleanly replaces the title h2 */}
          <div className="inner-layout">
            {children}
          </div>
        </div>
      </div>
    </div>
  );
};

export default AdminLayout;
