from app.db import database

COLLECTION_NAME = "payment_settings"

def get_payment_settings(db: database.MongoDB) -> dict:
    return db[COLLECTION_NAME].find_one({}) or {}

def update_payment_settings(data: dict, db: database.MongoDB) -> dict:
    db[COLLECTION_NAME].update_one({}, {"$set": data}, upsert=True)
    return get_payment_settings(db)
