from pydantic import BaseModel, Field
from datetime import datetime
from typing import Optional, Dict, Any

class AuditLogBase(BaseModel):
    action: str = Field(..., description="Action performed (e.g. 'create_account', 'update_subscription')")
    account_id: Optional[str] = Field(None, description="Account ID associated with the action")
    user_id: Optional[str] = Field(None, description="User ID who performed the action")
    details: Optional[Dict[str, Any]] = Field(None, description="Additional details about the action")
    ip_address: Optional[str] = Field(None, description="IP address from which the action was performed")

class AuditLogCreate(AuditLogBase):
    pass

class AuditLog(AuditLogBase):
    audit_id: str = Field(..., alias="_id")
    timestamp: datetime
