from pydantic import BaseModel, Field
from typing import List, Optional, Dict
from datetime import datetime

class TemplateBase(BaseModel):
    account_id: str
    template_name: str
    description: Optional[str] = None
    recurrence_rule: str
    task_definitions: List[str]  # Store task_id or a reference to task templates
    metadata: Optional[Dict] = None

class TemplateCreate(TemplateBase):
    pass

class Template(TemplateBase):
    template_id: str = Field(alias="_id")
    created_date: datetime = Field(default_factory=datetime.utcnow)

    class Config:
        populate_by_name = True
        json_encoders = {
            datetime: lambda dt: dt.isoformat()
        }

class TemplateList(BaseModel):
    total_count: int
    templates: List[Template]
