from pydantic import BaseModel, Field
from datetime import datetime
from typing import List, Optional, Dict
from enum import Enum

class Status(str, Enum):
    ACTIVE = "active"
    INACTIVE = "inactive"
    MAINTENANCE = "maintenance"

class ScheduleBase(BaseModel):
    #account_id: str
    account_id: Optional[str] = None
    schedule_name: str
    description: Optional[str] = None
    # start_time: datetime
    # end_time: datetime
    start_time: Optional[datetime] = None
    end_time: Optional[datetime] = None
    # task_ids: List[str] = []
    # workforce_id: Optional[str] = None
    # metadata: Optional[Dict] = {}
    task_ids: Optional[List[str]] = None
    workforce_id: Optional[str] = None
    metadata: Optional[Dict] = None
    status: Status = Field(default=Status.ACTIVE)

class ScheduleCreate(ScheduleBase):
    pass

class ScheduleUpdate(BaseModel):
    schedule_name: Optional[str] = None
    description: Optional[str] = None
    start_time: Optional[datetime] = None
    end_time: Optional[datetime] = None
    task_ids: Optional[List[str]] = None
    workforce_id: Optional[str] = None
    metadata: Optional[Dict] = None

class Schedule(ScheduleBase):
    schedule_id: str
    sch_id: Optional[int] = None
    created_date: datetime
    customer_info: Optional[dict] = None
    workforce_info: Optional[dict] = None
    fleet_info: Optional[dict] = None

class Schedules(BaseModel):
    total_count: int
    schedules: List[Schedule]

class ScheduleAssignmentRequest(BaseModel):
    schedule_id: str
    account_id: str
    workforce_id: str

class ScheduleSelectItem(BaseModel):
    schedule_id: str
    schedule_name: str

class ScheduleTravelStatusUpdateRequest(BaseModel):
    schedule_id: str
    travel_status: int

class TaskStop(BaseModel):
    location: str
    type: str
    sequence: int
    timing: Optional[datetime] = None
    customer_id: Optional[str] = None  # <-- added

class ScheduleWithTasksCreate(BaseModel):
    account_id: str
    start_time: Optional[datetime] = None
    end_time: Optional[datetime] = None
    description: Optional[str] = None
    task_stops: Optional[List[TaskStop]] = None  # <-- updated
