from enum import Enum
from datetime import datetime
from pydantic import BaseModel, Field
from typing import Optional, List, Dict
from jobs import JobStop
from bson import ObjectId


# ====================================================
# Route Model (represents a sequence of jobs or a fixed/dynamic route)
# ====================================================
# class RouteBase(BaseModel):
#     route_name: str = Field(..., description="Name or identifier for the route")
#     description: Optional[str] = Field("", description="Description of the route")
    
#     # Optionally assign a workforce and vehicle to the entire route
#     assigned_workforce_id: Optional[int] = Field(None, description="Workforce member assigned to the route")
#     assigned_vehicle_id: Optional[int] = Field(None, description="Vehicle assigned to the route")
    
#     # Timing for the route (if it is pre‑planned)
#     scheduled_start: Optional[datetime] = Field(None, description="Scheduled start time for the route")
#     scheduled_end: Optional[datetime] = Field(None, description="Scheduled end time for the route")
    
#     # Routes can have their own stops – these may represent a fixed itinerary,
#     # or a sequence of waypoints where jobs are (or will be) inserted dynamically.
#     route_stops: List[JobStop] = Field(default_factory=list, description="Ordered list of stops (waypoints) for the route")
    
#     # Alternatively, you can also store the list of job IDs that are part of this route.
#     job_ids: List[int] = Field(default_factory=list, description="List of job IDs assigned to this route")
    
#     total_distance: Optional[float] = Field(None, description="Total planned distance for the route")
#     metadata: Optional[Dict] = Field(default_factory=dict, description="Additional custom fields for the route")
    
#     created_date: datetime = Field(default_factory=datetime.utcnow, description="Timestamp when the route was created")
    
    class Config:
        orm_mode = True

# class RouteCreate(RouteBase):
#     pass

# class RouteUpdate(BaseModel):
#     route_name: Optional[str] = Field(None)
#     description: Optional[str] = Field(None)
#     assigned_workforce_id: Optional[int] = Field(None)
#     assigned_vehicle_id: Optional[int] = Field(None)
#     scheduled_start: Optional[datetime] = Field(None)
#     scheduled_end: Optional[datetime] = Field(None)
#     route_stops: Optional[List[JobStop]] = Field(None)
#     job_ids: Optional[List[int]] = Field(None)
#     total_distance: Optional[float] = Field(None)
#     metadata: Optional[Dict] = Field(None)

class RouteRead(RouteBase):
    route_id: int = Field(..., description="Unique identifier for the route")

# NEW Below
class TaskStop(BaseModel):
    stop_id: str
    name: str
    latitude: float
    longitude: float
    sequence: int

class RouteBase(BaseModel):
    account_id: str
    schedule_id: Optional[str]
    route_name: str
    description: Optional[str]
    scheduled_start: Optional[datetime]
    scheduled_end: Optional[datetime]
    route_stops: List[TaskStop]
    total_distance: Optional[float]
    total_duration: Optional[float]
    metadata: Optional[Dict]

class RouteCreate(RouteBase):
    pass

class RouteUpdate(RouteBase):
    pass

class Route(RouteBase):
    route_id: Optional[str]
    created_date: datetime = Field(default_factory=datetime.utcnow)

class RouteList(BaseModel):
    total_count: int
    routes: List[Route]