from app.v1.libraries.object import str_to_objectid
from fastapi import HTTPException

COLLECTION_NAME = "alert_category"

async def list_alert_categories_service(skip: int, limit: int, db):
    cursor = db[COLLECTION_NAME].find({}).skip(skip).limit(limit)

    categories = []
    for c in cursor:
        c["id"] = str(c["_id"])
        categories.append(c)

    total = db[COLLECTION_NAME].count_documents({})
    return {"total_count": total, "categories": categories}


async def get_alert_category_service(category_id: str, db):
    category = db[COLLECTION_NAME].find_one({"_id": str_to_objectid(category_id)})
    if not category:
        raise HTTPException(status_code=404, detail="Alert category not found")
    category["id"] = str(category["_id"])
    return category
