from app.db import database
from app.v1.libraries.object import str_to_objectid
from app.v1.models.platform.account_settings import (
    AccountSettings,
    BusinessProfile,
    PersonalInformation,
    BillingDetails
)

COLLECTION_NAME = "account_settings"

def get_account_settings(account_id: str, db):
    collection = db[COLLECTION_NAME]
    doc = collection.find_one({"account_id": account_id})
    if not doc:
        return AccountSettings()

    return AccountSettings(
        business_profile=BusinessProfile(**doc.get("business_profile", {})),
        personal_information=PersonalInformation(**doc.get("personal_information", {})),
        billing_details=BillingDetails(**doc.get("billing_details", {})),
    )

def update_account_settings(account_id: str, data: dict, db: database.MongoDB) -> dict:
    db[COLLECTION_NAME].update_one({"account_id": account_id}, {"$set": data}, upsert=True)
    return db[COLLECTION_NAME].find_one({"account_id": account_id})
