from fastapi import APIRouter, Depends
from app.db import database
from app.v1.models.platform.alertcategory import AlertCategoryList, AlertCategory
from app.v1.services.platform.alertcategory import (
    list_alert_categories_service,
    get_alert_category_service
)

router = APIRouter()

@router.get("/", response_model=AlertCategoryList)
async def list_alert_categories(
    skip: int = 0,
    limit: int = 10,
    db=Depends(database.get_mongo_db)
):
    return await list_alert_categories_service(skip, limit, db)


@router.get("/{category_id}", response_model=AlertCategory)
async def get_alert_category(category_id: str, db=Depends(database.get_mongo_db)):
    return await get_alert_category_service(category_id, db)
