from pydantic import BaseModel, Field
from typing import Optional, List, Dict
from datetime import datetime

class WayPoint(BaseModel):
    location: str
    type: str
    sequence: int
    timing: Optional[str] = None

class Coordinates(BaseModel):
    lat: float
    lng: float

class TaskBase(BaseModel):
    account_id: str
    schedule_id: Optional[str]
    service_id: str
    customer_id: Optional[str]
    scheduled_start: Optional[datetime]
    scheduled_end: Optional[datetime]
    actual_start: Optional[datetime]
    actual_end: Optional[datetime]
    status: str  # Enum if needed: "pending", "active", "completed", "cancelled"
    task_mode: str  # Enum: "scheduled", "on_demand", etc.
    priority: str  # Enum: "low", "normal", etc.
    roundtrip: bool
    capacity: Optional[int]
    variables: Optional[Dict] = {}
    addons: Optional[Dict] = {}
    checklist: Optional[Dict] = {}
    time_spent: Optional[float]
    distance_travelled: Optional[float]
    cost: Optional[float]
    task_stops: List[WayPoint] = []
    t_id: Optional[int] = None
    location: Optional[str] = None
    location_coords: Optional[Coordinates] = None 
    drop_location: Optional[str] = None         
    drop_location_coords: Optional[Coordinates] = None 
    type: Optional[str] = None
    sequence: Optional[int] = None
    timing: Optional[datetime] = None

class TaskCreate(TaskBase):
    pass

class TaskUpdate(BaseModel):
    status: Optional[str]
    task_mode: Optional[str]
    priority: Optional[str]
    actual_start: Optional[datetime]
    actual_end: Optional[datetime]
    roundtrip: Optional[bool]
    capacity: Optional[int]
    variables: Optional[Dict]
    addons: Optional[Dict]
    checklist: Optional[Dict]
    time_spent: Optional[float]
    distance_travelled: Optional[float]
    cost: Optional[float]
    task_stops: Optional[List[WayPoint]]

class Task(TaskBase):
    task_id: str
    t_id: Optional[int] = None
    created_date: datetime
    customer_info: Optional[dict] = None
    workforce_info: Optional[dict] = None
    fleet_info: Optional[dict] = None
    task_status: Optional[int] = None

class TaskList(BaseModel):
    total_count: int
    users: List[Task]

class TaskStatusUpdateRequest(BaseModel):
    task_id: str
    task_status: int

