from pydantic import BaseModel, Field, EmailStr
from datetime import datetime
from typing import Optional, List, Literal
from enum import Enum

class Status(str, Enum):
    ACTIVE = "active"
    INACTIVE = "inactive"
    MAINTENANCE = "maintenance"

class Condition(BaseModel):
    label: str
    applicable: Optional[bool] = True
    from_time: str  # You can use time if needed
    to_time: str
    calculation_type: Literal["amount", "percentage"]
    value: float

class PricingRule(BaseModel):
    account_id: str = Field(..., description="Identifier for the account")
    user_id: str = Field(..., description="Identifier for the user")
    rule_name: str = Field(..., description="Rule identifier")
    pricing_type: str = Field(..., description="Pricing type (e.g., fixed, time, distance)")
    base_cost: float = Field(..., description="Fixed base cost")
    rate: float = Field(..., description="Variable cost per unit")
    unit: str = Field(..., description="Unit for pricing (e.g., minute, km)")
    conditions: List[Condition] = Field(default_factory=list)
    created_date: datetime = Field(default_factory=datetime.utcnow, description="Creation timestamp")
    updated_date: datetime = Field(default_factory=datetime.utcnow, description="Last updated timestamp")
    pricing_type_value: str = Field(..., description="Pricing type value to showcase on the page. Valid options: 'Fixed', 'Time', 'Distance'.")
    status: Status = Field(default=Status.ACTIVE)

class PricingRuleList(BaseModel):
    account_id: str = Field(..., description="Identifier for the account")
    user_id: str = Field(..., description="Identifier for the user")
    id: str = Field(..., description="Identifier for the user")
    rule_name: str = Field(..., description="Rule identifier")
    pricing_type: str = Field(..., description="Pricing type (e.g., fixed, time, distance)")
    base_cost: float = Field(..., description="Fixed base cost")
    rate: float = Field(..., description="Variable cost per unit")
    unit: str = Field(..., description="Unit for pricing (e.g., minute, km)")
    conditions: List[Condition] = Field(default_factory=list)
    created_date: datetime = Field(default_factory=datetime.utcnow, description="Creation timestamp")
    updated_date: datetime = Field(default_factory=datetime.utcnow, description="Last updated timestamp")
    pricing_type_value: str = Field(..., description="Pricing type value to showcase on the page. Valid options: 'Fixed', 'Time', 'Distance'.")
    status: str = Field(..., description="Status of the pricing rule (e.g., active, inactive)")
    #id: str = Field(..., alias="_id", description="MongoDB document ID") 
    pricing_rules_id: int = Field(..., description="Unique Identifier for the pricing rule") 

class PricingRules(BaseModel):
    total_count: int
    users: List[PricingRuleList]

class PricingRuleStatusUpdate(BaseModel):
    status: str