from pydantic import BaseModel
from typing import Optional
from datetime import datetime
from bson import ObjectId

class AlertCategory(BaseModel):
    id: Optional[str] = None
    category_name: str

    class Config:
        json_encoders = {ObjectId: str}


class AlertCategoryList(BaseModel):
    total_count: int
    categories: list[AlertCategory]
