features_list = {
    "saas": [
        {
            "id": 1,
            "name": "Dashboard",
            "display": True,
            "url": "/saas/dash",
            "apiurl": "/v1/dash",
            "icon": "dashboard",
            "description": "SaaS Dashboard for quick overview"
        },
        {
            "id": 2,
            "name": "Accounts",
            "display": True,
            "url": "/saas/accounts",
            "apiurl": "/v1/accounts",
            "icon": "storefront",
            "description": "Manage SaaS account information"
        },
        {
            "id": 3,
            "name": "Subscriptions",
            "display": True,
            "url": "/saas/subscriptions",
            "apiurl": "/v1/subscriptions",
            "icon": "loyalty",
            "description": "Handle subscription plans and renewals"
        },
        {
            "id": 4,
            "name": "Invoices",
            "display": True,
            "url": "/saas/invoices",
            "apiurl": "",
            "icon": "paid",
            "description": "View and manage invoices"
        },
        {
            "id": 5,
            "name": "Account Dashboard",
            "display": False,
            "url": "/saas/account-dashboard",
            "apiurl": "",
            "icon": "account_dashboard",
            "description": "Detailed dashboard for account performance"
        },
        {
            "id": 6,
            "name": "Partners",
            "display": True,
            "url": "/saas/partners",
            "icon": "face",
            "description": "Manage partner information"
        },
        {
            "id": 7,
            "name": "Users",
            "display": True,
            "url": "/saas/users",
            "icon": "account_circle",
            "description": "User management (Superadmin only)"
        },
        {
            "id": 8,
            "name": "Roles",
            "display": True,
            "url": "/saas/roles",
            "icon": "key",
            "description": "Manage system roles (Superadmin only)"
        },
        {
            "id": 9,
            "name": "Apps",
            "display": True,
            "url": "/saas/apps",
            "icon": "apps",
            "description": "Manage SaaS applications (Superadmin only)"
        },
        {
            "id": 10,
            "name": "CRM",
            "display": False,
            "url": "/saas/crm",
            "icon": "crm",
            "description": "Customer relationship management module"
        },
        {
            "id": 11,
            "name": "Tickets",
            "display": True,
            "url": "/saas/tickets",
            "icon": "help",
            "description": "Support ticket management"
        },
        {
            "id": 12,
            "name": "Communication",
            "display": False,
            "url": "/saas/communication",
            "icon": "communication",
            "description": "Internal communication tools"
        },
        {
            "id": 13,
            "name": "Settings",
            "display": True,
            "url": "/saas/settings",
            "icon": "settings",
            "description": "System and account settings (Superadmin only)"
        },
        {
            "id": 14,
            "name": "Payments",
            "display": True,
            "url": "/saas/payments",
            "icon": "settings",
            "description": "Payments list (Superadmin only)"
        },
    ],
    "platform": [
        {
            "id": 21,
            "name": "Dashboard",
            "display": True,
            "url": "/dasha",
            "icon": "dashboard",
            "description": "Platform Dashboard for Admins, Managers, Finance, Vendors"
        },
        {
            "id": 22,
            "name": "Home",
            "display": True,
            "url": "/dashc",
            "icon": "dashboard",
            "description": "Customer Dashboard"
        },
        {
            "id": 23,
            "name": "Booking",
            "display": True,
            "url": "/booking",
            "icon": "star",
            "description": "Booking management for customers"
        },
        {
            "id": 24,
            "name": "Track",
            "display": True,
            "url": "/track",
            "icon": "explore",
            "description": "Track your orders and deliveries"
        },
        {
            "id": 25,
            "name": "Dispatch",
            "display": True,
            "url": "/dispatch",
            "icon": "schedule_send",
            "description": "Dispatch orders and manage deliveries"
        },
        {
            "id": 26,
            "name": "Fleet",
            "display": True,
            "url": "/fleet",
            "icon": "directions_car",
            "description": "Fleet management for logistics"
        },
        {
            "id": 27,
            "name": "Workforce",
            "display": True,
            "url": "/workforce",
            "icon": "group",
            "description": "Manage workforce resources"
        },
        {
            "id": 28,
            "name": "Services",
            "display": True,
            "url": "/services",
            "icon": "linked_services",
            "description": "Manage available platform services"
        },
        {
            "id": 29,
            "name": "Tasks",
            "display": True,
            "url": "/tasks",
            "icon": "task",
            "description": "Job management and scheduling"
        },
        {
            "id": 30,
            "name": "Schedules",
            "display": True,
            "url": "/schedules",
            "icon": "schedule",
            "description": "Manage platform schedules"
        },
        {
            "id": 31,
            "name": "Customers",
            "display": True,
            "url": "/customers",
            "icon": "supervised_user_circle",
            "description": "Customer management"
        },
        {
            "id": 32,
            "name": "Transactions",
            "display": True,
            "url": "/payments",
            "icon": "paid",
            "description": "Manage financial transactions"
        },
        {
            "id": 33,
            "name": "Marketplace",
            "display": True,
            "url": "/marketplace",
            "icon": "apps",
            "description": "Platform marketplace management"
        },
        {
            "id": 34,
            "name": "Settings",
            "display": True,
            "url": "/settings",
            "icon": "settings",
            "description": "Platform settings"
        },
        {
            "id": 35,
            "name": "Users",
            "display": True,
            "url": "/users",
            "icon": "account_circle",
            "description": "Manage platform users"
        }
    ]
}


# 3. Create/Update default system roles and their permissions mapping
default_roles = [
    {"role_id": 1, "name": "Superadmin", "description": "Global super administrator with complete access to all system features and settings.", "is_system_default": True, "is_global_access": True, "is_saas_only": True},
    {"role_id": 2, "name": "Sales/Accounts", "description": "Role focused on client management with access to sales data while restricting access to Users, Roles, Apps, and Settings.", "is_system_default": True, "is_global_access": True, "is_saas_only": True},
    {"role_id": 3, "name": "Partner", "description": "Primary partner role with essential management permissions and controlled access to critical functions.", "is_system_default": True, "is_global_access": False, "is_saas_only": True},
    {"role_id": 4, "name": "Partner - Sales/Accounts", "description": "Role for partner sales and account personnel with focused permissions to handle daily operations.", "is_system_default": True, "is_global_access": False, "is_saas_only": True},
    {"role_id": 5, "name": "Tech Team", "description": "Technical support role with permissions tailored for system maintenance, troubleshooting, and operational support.", "is_system_default": True, "is_global_access": False, "is_saas_only": True},
    {"role_id": 100, "name": "Account Owner", "description": "Principal account administrator with full control over all account settings and functionalities.", "is_system_default": True, "is_global_access": True},
    {"role_id": 101, "name": "Manager", "description": "Manager with permissions to view and update key account data without full administrative privileges.", "is_system_default": True, "is_global_access": True},
    {"role_id": 102, "name": "Finance", "description": "Finance role with complete access to transactions and invoices, while retaining read-only access to other modules.", "is_system_default": True, "is_global_access": True},
    {"role_id": 103, "name": "Workforce", "description": "Role with restricted access limited to workforce management functions.", "is_system_default": True, "is_global_access": False},
    {"role_id": 104, "name": "Customer", "description": "Customer role providing read-only access to dashboards and booking functionalities.", "is_system_default": True, "is_global_access": True},
    {"role_id": 105, "name": "Vendor", "description": "Vendor role with limited access confined to the modules required for managing vendor-related activities.", "is_system_default": True, "is_global_access": False},
]
    