from fastapi import APIRouter, Depends
from app.db import get_db
from app.v1.models.route import Route, RouteCreate, RouteUpdate
from app.v1.platform.routes import (
    create_route_service,
    get_route_service,
    get_routes_service,
    update_route_service,
    delete_route_service
)

router = APIRouter()

@router.post("/", response_model=Route)
def create_route(route: RouteCreate, db=Depends(get_db)):
    return create_route_service(route, db)

@router.get("/{route_id}", response_model=Route)
def get_route(route_id: str, db=Depends(get_db)):
    return get_route_service(route_id, db)

@router.get("/", response_model=dict)
def list_routes(skip: int = 0, limit: int = 10, account_id: str = None, db=Depends(get_db)):
    return get_routes_service(skip, limit, account_id, db)

@router.put("/{route_id}", response_model=Route)
def update_route(route_id: str, route: RouteUpdate, db=Depends(get_db)):
    return update_route_service(route_id, route, db)

@router.delete("/{route_id}", response_model=Route)
def delete_route(route_id: str, db=Depends(get_db)):
    return delete_route_service(route_id, db)
