from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.payment import PaymentSettings
from app.v1.services.platform import payment as payment_service

router = APIRouter()

@router.get("/", response_model=PaymentSettings)
def get_settings(db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return payment_service.get_payment_settings(db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/", response_model=PaymentSettings)
def update_settings(settings: PaymentSettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return payment_service.update_payment_settings(settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
