from pydantic import BaseModel
from typing import List, Dict, Any

class OverviewMetrics(BaseModel):
    users_count: int
    active_subscriptions: int
    active_projects: int
    total_revenue: float
    last_updated: str

class OverviewWorkfoceFleet(BaseModel):
    workforce_count: int
    fleets_count: int
    vendors_count: int
    users_count: int

class TrendData(BaseModel):
    _id: str  # Date string
    daily_logins: int = 0
    daily_revenue: float = 0.0

class DashboardData(BaseModel):
    overview: OverviewMetrics
    usage_trends: List[Dict[str, Any]]
    revenue_trends: List[Dict[str, Any]]
    workforce_fleet_trends: OverviewWorkfoceFleet
    date_range: Dict[str, str]
