from pydantic import BaseModel, Field
from bson import ObjectId
from datetime import datetime
from typing import Optional, List


class CommunicationEmailBase(BaseModel):
    account_id: str = Field(..., description="Identifier for the account; required.")
    status: str = Field(..., description="Current status of the ticket (e.g., failed, success).")
    email_from: str = Field(..., description="Sender email address.")
    email_to: str = Field(..., description="Recipient email address.")
    email_title: str = Field(..., description="Subject or title of the email.")
    email_description: str = Field(..., description="Content of the email.")
    user_id: str = Field(..., description="Identifier for the user associated with this email.")


class CommunicationEmailCreate(CommunicationEmailBase):
    pass


class CommunicationEmail(CommunicationEmailBase):
    id: str
    created_date: datetime = Field(default_factory=datetime.utcnow)

    class Config:
        arbitrary_types_allowed = True
        json_encoders = {ObjectId: str}
        populate_by_name = True
        from_attributes = True


class CommunicationEmailResponse(BaseModel):
    email_id: str
    account_id: str
    status: str
    email_from: str
    email_to: str
    email_title: str
    email_description: str
    user_id: str
    created_date: datetime


class CommunicationEmailResponseList(BaseModel):
    total_count: int
    emails: List[CommunicationEmailResponse]


class CommunicationEmailUpdate(BaseModel):
    status: Optional[str]
    email_description: Optional[str]
