import React from 'react';
import { createRoot } from 'react-dom/client';
import AppRoutes from './components/routes/AppRoutes';
import reportWebVitals from './reportWebVitals';
import axios from 'axios';
//import { RBACProvider } from './state/RBACContext';
import { Provider } from 'react-redux';
import { Store } from './state/Store';

import './components/themes/blue/index.css';

// Import i18n setup
import './i18n';
import { I18nextProvider } from 'react-i18next';
import i18n from './i18n';

//axios.defaults.baseURL = 'http://localhost:8000/api/v1/';
const currentDomain = window.location.hostname;

if (currentDomain === "localhost") {
  axios.defaults.baseURL = 'http://172.173.201.201:8003/v1/';
} else if (currentDomain === "movex.ai" || currentDomain === "www.movex.ai" || currentDomain === "beta.movex.ai") {
  axios.defaults.baseURL = 'http://172.173.201.201:8003/v1/';
} 

axios.defaults.withCredentials = true;

const root = createRoot(document.getElementById('root'));
const tokenvalue = localStorage.getItem('token')||'';

root.render(
  <Provider store={Store}>
    <I18nextProvider i18n={i18n}>
      <AppRoutes />
    </I18nextProvider>
  </Provider>
);

reportWebVitals();

//axios.defaults.headers.common['Authorization'] = `Bearer ${tokenvalue}`;
/*
root.render(
  <React.StrictMode>
    <AppRoutes />
  </React.StrictMode>
);
*/

