from fastapi import APIRouter, Depends, HTTPException, Query
from datetime import datetime
from app.db import database
from ...dependencies.auth import get_current_userdetails
from ...models.saas.dashboardmodel import DashboardData  # Pydantic model for dashboard response
from ...services.saas.dashboard import get_dashboard_metrics_service

router = APIRouter()

@router.get("/metrics", response_model=DashboardData)
async def get_dashboard_metrics(
    db: database.MongoDB = Depends(database.get_mongo_db),
    current_user = Depends(get_current_userdetails),
    start_date: str = Query(None, description="Start date in ISO format"),
    end_date: str = Query(None, description="End date in ISO format")
):
    """
    Returns comprehensive dashboard metrics including overview stats,
    usage trends, and revenue trends. Optional date filters can be applied.
    """
    try:
        start_dt = datetime.fromisoformat(start_date) if start_date else None
        end_dt = datetime.fromisoformat(end_date) if end_date else None
        metrics = await get_dashboard_metrics_service(db, current_user, start_dt, end_dt)
        return metrics
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
