from fastapi import APIRouter
from enum import EnumMeta
import inspect
from ... import models  # adjust path if needed
from ...models import common as common_enums

router = APIRouter()

def extract_enums(module):
    enums = {}
    for name, obj in inspect.getmembers(module):
        if isinstance(obj, EnumMeta):
            enums[name] = [e.value for e in obj]
    return enums

@router.get("/")
def get_enums():
    combined_enums = {}
    combined_enums.update(extract_enums(common_enums))
    #combined_enums.update(extract_enums(platform_common_enums))
    return combined_enums
