# app/v1/models/saas/zerodha.py

from pydantic import BaseModel, Field
from typing import Optional

class ZerodhaSettingsBase(BaseModel):
    api_key: str
    api_secret: str
    redirect_url: str
    user_id: str

class ZerodhaSettingsCreate(ZerodhaSettingsBase):
    pass

class ZerodhaSettingsUpdate(BaseModel):
    api_key: Optional[str]
    api_secret: Optional[str]
    redirect_url: Optional[str]

class ZerodhaSettingsOut(ZerodhaSettingsBase):
    id: str = Field(alias="_id")  # ✅ Correct for MongoDB
