from pydantic import BaseModel, Field
from datetime import datetime
from typing import Optional, Dict, Any

class SupportActivityBase(BaseModel):
    type: str = Field(
        ...,
        description="Type of activity (e.g. 'comment', 'meeting', 'note', 'pipeline_update')"
    )
    account_id: str = Field(
        ...,
        description="ID of the account associated with this activity"
    )
    user_id: Optional[str] = Field(
        None,
        description="ID of the user performing the activity"
    )
    content: Optional[str] = Field(
        None,
        description="Main content (e.g. comment text, meeting notes, etc.)"
    )
    additional_data: Optional[Dict[str, Any]] = Field(
        None,
        description="Extra details such as meeting scheduled_date, or for pipeline updates, the old and new statuses"
    )

class SupportActivityCreate(SupportActivityBase):
    pass

class SupportActivityUpdate(BaseModel):
    content: Optional[str] = Field(
        None,
        description="Updated content for the activity"
    )
    additional_data: Optional[Dict[str, Any]] = Field(
        None,
        description="Updated extra details for the activity"
    )

class SupportActivity(SupportActivityBase):
    activity_id: str = Field(..., alias="_id")
    created_date: datetime
