# app/models/invoice.py
from datetime import date
from typing import Optional
from pydantic import BaseModel, Field
from ..common import InvoiceStatus, InvoiceType
from ..basemodel import CommonBase

class SaaSInvoiceBase(BaseModel):
    account_id: str = Field(..., description="Client account ID")
    active_subscription_id: Optional[str] = Field(
        None, description="Pulled from the account"
    )
    invoice_type: InvoiceType = Field(..., description="One‑Time, Recurring, etc.")
    invoice_title: str = Field(..., description="Short title for the invoice")
    invoice_description: Optional[str] = Field(
        None, description="Line items or notes"
    )
    amount: float = Field(..., description="Invoice amount")
    currency: str = Field(..., description="Currency code (USD, INR, ...)")
    status: InvoiceStatus = Field(..., description="Paid, Unpaid, Overdue, ...")
    invoice_date: date = Field(..., description="Date issued")
    due_date: date = Field(..., description="Date due")
    user_id: str = Field(..., description="Creator user ID")

class SaaSInvoiceCreate(SaaSInvoiceBase):
    pass

class SaaSInvoiceUpdate(BaseModel):
    status: InvoiceStatus

class SaaSInvoiceDB(CommonBase, SaaSInvoiceBase):
    invoice_id: str
