from enum import Enum
from pydantic import BaseModel, Field, validator, root_validator, EmailStr
from datetime import datetime
from dateutil import parser  # pip install python-dateutil
from typing import Optional, List
from ..common import Address, SubscriptionStatus, SubscriptionType, AccountType
# Import the common model


class AccountBase(BaseModel):
    full_name: str
    email: EmailStr
    phone: Optional[str] = None
    company_name: Optional[str] = None  # Optional for professionals
    address: Optional[Address] = None
    user_id: Optional[str] = ""  # Master User Id

    is_active: bool = True
    created_date: Optional[datetime] = Field(default_factory=datetime.utcnow)
    updated_date: Optional[datetime] = Field(default_factory=datetime.utcnow)

    # Subscription information
    account_type: AccountType = Field(default=AccountType.ACCOUNT)
    active_subscription_id: Optional[str] = None
    subscription_status: SubscriptionStatus = Field(default=SubscriptionStatus.trial)
    subscription_type: SubscriptionType = Field(default=SubscriptionType.FREE)


class Account(AccountBase):
    account_id: Optional[str] = None


class AccountCreate(AccountBase):
    pass


class AccountUpdate(AccountBase):
    pass


class AccountList(AccountBase):
    account_id: str


class Accounts(BaseModel):
    total_count: int
    accounts: list[AccountList]


class AccountQueryParams(BaseModel):
    skip: int = 0
    limit: int = 10
    account_id: Optional[str] = None
    email: Optional[str] = None
    phone: Optional[str] = None
    is_active: Optional[bool] = None
    reg_date_from: Optional[datetime] = None
    reg_date_to: Optional[datetime] = None
