features_list = {
    "saas": [
        {
            "id": 1,
            "name": "Dashboard",
            "display": True,
            "url": "/saas/dash",
            "apiurl": "/v1/dash",
            "icon": "dashboard",
            "description": "SaaS Dashboard for quick overview"
        },
        {
            "id": 2,
            "name": "Accounts",
            "display": True,
            "url": "/saas/accounts",
            "apiurl": "/v1/accounts",
            "icon": "storefront",
            "description": "Manage account details"
        },
        {
            "id": 3,
            "name": "Subscriptions",
            "display": True,
            "url": "/saas/subscriptions",
            "apiurl": "/v1/subscriptions",
            "icon": "loyalty",
            "description": "Subscription and billing"
        },
        {
            "id": 4,
            "name": "Invoices",
            "display": True,
            "url": "/saas/invoices",
            "apiurl": "",
            "icon": "paid",
            "description": "View billing history"
        },
        {
            "id": 7,
            "name": "Users",
            "display": True,
            "url": "/saas/users",
            "icon": "account_circle",
            "description": "Manage user access"
        },
        {
            "id": 8,
            "name": "Roles",
            "display": True,
            "url": "/saas/roles",
            "icon": "key",
            "description": "Permission and role control"
        },
        {
            "id": 13,
            "name": "Settings",
            "display": True,
            "url": "/saas/settings",
            "icon": "settings",
            "description": "System and platform settings"
        }
    ],
    "platform": [
        {
            "id": 21,
            "name": "Dashboard",
            "display": True,
            "url": "/dash",
            "icon": "dashboard",
            "description": "Trader admin dashboard"
        },
        {
            "id": 22,
            "name": "Signals",
            "display": True,
            "url": "/signals",
            "icon": "insights",
            "description": "View AI trading signals"
        },
        {
            "id": 23,
            "name": "Watchlist",
            "display": True,
            "url": "/watchlist",
            "icon": "visibility",
            "description": "Track preferred stocks or assets"
        },
        {
            "id": 24,
            "name": "Portfolio",
            "display": True,
            "url": "/portfolio",
            "icon": "pie_chart",
            "description": "View current holdings"
        },
        {
            "id": 25,
            "name": "Individual Stock",
            "display": True,
            "url": "/live",
            "icon": "airwave",
            "description": "View Stock Data"
        },
        {
            "id": 26,
            "name": "Stream",
            "display": True,
            "url": "/stream",
            "icon": "candlestick_chart",
            "description": "View Live Signals"
        },
        {
            "id": 27,
            "name": "Transactions",
            "display": True,
            "url": "/payments",
            "icon": "receipt_long",
            "description": "Trade history and financial logs"
        },
        {
            "id": 34,
            "name": "Settings",
            "display": True,
            "url": "/settings",
            "icon": "settings",
            "description": "Update personal preferences"
        }
    ]
}


# 3. Create/Update default system roles and their permissions mapping
default_roles = [
    {"role_id": 1, "name": "Superadmin", "description": "Global super administrator with complete access to all system features and settings.", "is_system_default": True, "is_global_access": True, "is_saas_only": True},
    {"role_id": 2, "name": "Sales/Accounts", "description": "Role focused on client management with access to sales data while restricting access to Users, Roles, Apps, and Settings.", "is_system_default": True, "is_global_access": True, "is_saas_only": True},
    {"role_id": 5, "name": "Tech Team", "description": "Technical support role with permissions tailored for system maintenance, troubleshooting, and operational support.", "is_system_default": True, "is_global_access": False, "is_saas_only": True},
    {"role_id": 100, "name": "Account Owner", "description": "Principal account administrator with full control over all account settings and functionalities.", "is_system_default": True, "is_global_access": True},
    {"role_id": 101, "name": "Manager", "description": "Manager with permissions to view and update key account data without full administrative privileges.", "is_system_default": True, "is_global_access": True},
]
    
