from datetime import datetime
from pydantic import BaseModel, Field
from typing import Optional, List, TypeVar, Generic
from pydantic.generics import GenericModel

# Common fields used for all models.
class CommonBase(BaseModel):
    account_id: Optional[str] = None  # Identifier for account ownership
    user_id: Optional[str] = None       # Identifier for who performed the operation
    created_date: Optional[datetime] = Field(default_factory=datetime.utcnow)
    updated_date: Optional[datetime] = Field(default_factory=datetime.utcnow)
