from googleapiclient.discovery import build

# Replace 'YOUR_API_KEY' with your actual YouTube Data API v3 key
api_key = 'YOUR_API_KEY'
youtube = build('youtube', 'v3', developerKey=api_key)

def get_video_details(video_id):
    # Fetch the video details
    request = youtube.videos().list(
        part="snippet",
        id=video_id
    )
    response = request.execute()
    
    if response['items']:
        # Assuming the video ID is valid and results are returned
        video_details = response['items'][0]['snippet']
        title = video_details['title']
        keywords = video_details.get('tags', [])
        
        return {
            "title": title,
            "keywords": keywords
        }
    else:
        return {
            "title": "Video title not found",
            "keywords": []
        }

# Example usage
video_id = 'dQw4w9WgXcQ'  # Replace with the actual video ID
details = get_video_details(video_id)
print(f"Title: {details['title']}")
print(f"Keywords: {', '.join(details['keywords'])}")
